// alumno_instrumentos.js
(function($, window, document){
  'use strict';

  const ID_MOD = window.APP?.ID_MOD || 0;
  const ANNO   = window.APP?.ANNO   || '';
  let DRAFT_ID = null;

  // Helpers
  const option = (label, value) => `<option value="${value}">${label}</option>`;
  const annoActual = () => ($('#f_anno').length ? ($('#f_anno').val()||'').trim() : (ANNO||'').trim());

  // ---- API borrador ----
  function draftStart(){
    return $.ajax({
      url:'draft_start.php', method:'POST',
      data: JSON.stringify({ id_modulo: ID_MOD, anno: annoActual() }),
      contentType:'application/json; charset=utf-8', dataType:'json'
    }).done(r=>{
      if(!r.ok) throw new Error(r.error||'No se pudo iniciar borrador');
      DRAFT_ID = r.draft_id;
    });
  }
  function draftAdd(ids){
    if(!ids || !ids.length) return $.Deferred().resolve();
    return $.ajax({
      url:'draft_add_criterios.php', method:'POST',
      data: JSON.stringify({ draft_id: DRAFT_ID, ids: ids.map(Number) }),
      contentType:'application/json; charset=utf-8', dataType:'json'
    });
  }
  function draftRemove(ids){
    return $.ajax({
      url:'draft_remove_criterios.php', method:'POST',
      data: JSON.stringify({ draft_id: DRAFT_ID, ids: (ids||[]).map(Number) }),
      contentType:'application/json; charset=utf-8', dataType:'json'
    });
  }
  function draftList(){
    return $.getJSON('draft_list.php',{ draft_id: DRAFT_ID });
  }
  function draftSetMeta(meta){
    return $.ajax({
      url:'draft_set_meta.php', method:'POST',
      data: JSON.stringify(Object.assign({draft_id:DRAFT_ID}, meta)),
      contentType:'application/json; charset=utf-8', dataType:'json'
    });
  }
  function draftSetAlumnos(asignar_todos, alumnos){
    return $.ajax({
      url:'draft_set_alumnos.php', method:'POST',
      data: JSON.stringify({ draft_id:DRAFT_ID, asignar_todos: asignar_todos?1:0, alumnos: (alumnos||[]).map(Number)}),
      contentType:'application/json; charset=utf-8', dataType:'json'
    });
  }
  function draftCommit(){
    return $.ajax({
      url:'draft_commit.php', method:'POST',
      data: JSON.stringify({ draft_id: DRAFT_ID }),
      contentType:'application/json; charset=utf-8', dataType:'json'
    });
  }

  // ---- RA y criterios ----
  function cargarRA(){
    const $ra = $('#dlg_ra').empty().append('<option value="">Cargando…</option>');
    return $.getJSON('ra_list.php',{id_modulo:ID_MOD}).done(rows=>{
      $ra.empty();
      if(!rows || !rows.length){ $ra.append('<option value="">(Sin RA)</option>'); return; }
      rows.forEach(r=>{
        const etiqueta = r.descripcion ? `${r.codigo} · ${r.descripcion}` : (r.codigo || `RA ${r.id}`);
        $ra.append(option(etiqueta, r.id));
      });
      $ra.trigger('change');
    }).fail((xhr)=>{
      $ra.empty().append('<option value="">(Error cargando RA)</option>');
      console.error('Error RA', xhr.status, xhr.responseText);
      alert('No se pudieron cargar los RA.');
    });
  }

  function cargarDisponiblesDelRA(){
    const id_ra = $('#dlg_ra').val();
    const $av = $('#dlg_criterios_av').empty();
    if(!id_ra) return $.Deferred().resolve();

    return $.getJSON('criterios_list.php', { id_modulo: ID_MOD, ra: [id_ra] }).then(rows=>{
      return draftList().then(dr=>{
        const sel = new Set((dr.criterios||[]).map(c=> String(c.id)));
        rows.forEach(r=>{
          if(!sel.has(String(r.id))){
            $av.append(option(`${r.codigo_ra} · ${r.criterio} (v=${r.valor})`, r.id));
          }
        });
        aplicarFiltroDisponibles();
      });
    });
  }

  function renderSeleccionados(){
  const $sel = $('#dlg_criterios_sel');
  if(!$sel.length){ console.warn('#dlg_criterios_sel no existe'); return; }
  $sel.empty();

  if(!DRAFT_ID){ 
    console.warn('DRAFT_ID aún no inicializado');
    return;
  }

  draftList()
    .done(dr=>{
      if(!dr || dr.ok === false){
        console.warn('draft_list error:', dr?.error);
        return;
      }
      const rows = Array.isArray(dr.criterios) ? dr.criterios : [];
      if(rows.length === 0){
        // Muestra un placeholder opcional (comentado si no te gusta)
        // $sel.append('<option disabled>(Sin criterios seleccionados)</option>');
        return;
      }
      rows.sort((a,b)=> (a.codigo_ra||'').localeCompare(b.codigo_ra||'') || (a.id - b.id));
      rows.forEach(r=>{
        const cod = r.codigo_ra || 'RA';
        const etiqueta = `${cod} · ${r.criterio} (v=${r.valor ?? ''})`;
        $sel.append(new Option(etiqueta, r.id));
      });
    })
    .fail((xhr)=>{
      console.error('draft_list fail:', xhr.status, xhr.responseText);
      alert('No se pudieron cargar los criterios del borrador (draft_list).');
    });
}


  // ---- Filtro disponibles ----
  function aplicarFiltroDisponibles(){
    const q = ($('#filtro_av').val()||'').toLowerCase();
    $('#dlg_criterios_av option').each(function(){
      const show = $(this).text().toLowerCase().includes(q);
      $(this).toggle(show);
    });
  }

  // ---- Alumnos ----
  function cargarAlumnosMatriculados(){
    const a = annoActual(); if(!a){ return $.Deferred().reject(); }
    return $.getJSON('alumnos_matriculados_list.php',{id_modulo:ID_MOD, anno:a})
      .done(rows=>{
        const $s = $('#dlg_sel_alumnos').empty();
        rows.forEach(al=>{
          const nombre = [al.nombre, al.apellidos || ((al.apellido1||'')+' '+(al.apellido2||''))].filter(Boolean).join(' ');
          $s.append(option(`${nombre} (#${al.id})`, al.id));
        });
      });
  }

  // ---- Eventos UI ----
  $(function(){

    // Cambiar RA -> recargar disponibles (no toca los seleccionados, que viven en el borrador)
    $('#dlg_ra').on('change', function(){ cargarDisponiblesDelRA(); });

    // Filtro de disponibles
    $('#filtro_av').on('input', aplicarFiltroDisponibles);

 
 // Añadir seleccionados del RA actual
$('#btn_add').off('click').on('click', function(){
  const ids = ($('#dlg_criterios_av').val()||[]).map(Number);
  if(!ids.length) return;
  draftAdd(ids)
    .done(()=>{
      cargarDisponiblesDelRA();   // repuebla la izquierda SIN los añadidos
      renderSeleccionados();      // repinta la derecha con TODO el borrador
    })
    .fail(()=> alert('Error al añadir criterios al borrador'));
});

// Añadir todos
$('#btn_add_all').off('click').on('click', function(){
  const ids = $('#dlg_criterios_av option').map((_,o)=> Number($(o).value)).get();
  if(!ids.length) return;
  draftAdd(ids)
    .done(()=>{ cargarDisponiblesDelRA(); renderSeleccionados(); })
    .fail(()=> alert('Error al añadir todos al borrador'));
});

// Quitar seleccionados de la derecha
$('#btn_remove').off('click').on('click', function(){
  const ids = ($('#dlg_criterios_sel').val()||[]).map(Number);
  if(!ids.length) return;
  draftRemove(ids)
    .done(()=>{ cargarDisponiblesDelRA(); renderSeleccionados(); })
    .fail(()=> alert('Error al quitar criterios del borrador'));
});

// Quitar todos
$('#btn_remove_all').off('click').on('click', function(){
  draftRemove([]) // tu endpoint acepta vacío = quitar todos
    .done(()=>{ cargarDisponiblesDelRA(); renderSeleccionados(); })
    .fail(()=> alert('Error al vaciar el borrador'));
});

 
 
 
 
 
 

    // Doble clic
    $('#dlg_criterios_av').on('dblclick', function(){ $('#btn_add').click(); });
    $('#dlg_criterios_sel').on('dblclick', function(){ $('#btn_remove').click(); });

    // Abrir diálogo
$('#btn_dialogo_inst').off('click').on('click', function(){
  const a = ($('#f_anno').val()||ANNO||'').trim();
  if(!a){ alert('Indica el año académico'); return; }

  $('#frm_dlg')[0].reset();
  $('#dlg_id').val('');
  $('#dlg_asignar_todos').prop('checked', true);
  $('#dlg_sel_alumnos').prop('disabled', true);

  $.when(
    draftStart(),        // crea borrador y setea DRAFT_ID
    cargarRA(),          // llena #dlg_ra y dispara change
    cargarAlumnosMatriculados()
  ).always(()=>{
    renderSeleccionados(); // pinta lo que ya haya en el borrador (normalmente vacío)
  });

  $('#dlg_inst').dialog({
    modal:true, width: 780,
    buttons: {
      'Guardar instrumento': function(){
        // ... (tu commit como ya tenías)
      },
      'Cancelar': function(){ $(this).dialog('close'); }
    }
  });
});


  });

})(jQuery, window, document);

