<?php
// alumno_matriculas.php (PRODUCCIÓN, usa $conn como PDO)
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');

function out_json($data, int $code = 200) {
  http_response_code($code);
  echo json_encode($data, JSON_UNESCAPED_UNICODE);
  exit;
}

try {
  require_once __DIR__ . '/includes/db.php'; // aquí defines $conn como PDO

  // Aceptamos $pdo o $conn (PDO)
  if (isset($pdo) && $pdo instanceof PDO) {
    // ok
  } elseif (isset($conn) && $conn instanceof PDO) {
    $pdo = $conn; // <<--- usamos tu $conn (PDO) como $pdo
  } else {
    throw new RuntimeException('No hay PDO disponible: ni $pdo ni $conn son PDO.');
  }

  $id_alumno = isset($_GET['id_alumno']) ? (int)$_GET['id_alumno'] : 0;
  $anno      = isset($_GET['anno']) ? trim((string)$_GET['anno']) : '';

  if ($id_alumno <= 0) out_json(['error' => 'id_alumno requerido'], 400);

  $sql = "SELECT am.id, am.id_alumno, am.id_modulo, am.anno, am.fecha,
                 COALESCE(m.nombre,'(sin nombre)') AS modulo_nombre
          FROM alumnos_modulos am
          LEFT JOIN modulos m ON m.id = am.id_modulo
          WHERE am.id_alumno = :id_alumno";
  $params = [':id_alumno' => $id_alumno];

  if ($anno !== '') {
    $sql .= " AND am.anno = :anno";
    $params[':anno'] = $anno;
  }
  $sql .= " ORDER BY am.anno DESC, modulo_nombre ASC";

  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $st = $pdo->prepare($sql);
  foreach ($params as $k => $v) $st->bindValue($k, $v);
  $st->execute();
  $rows = $st->fetchAll(PDO::FETCH_ASSOC);

  out_json($rows ?: []);

} catch (Throwable $e) {
  error_log('[alumno_matriculas] '.$e->getMessage());
  out_json(['error' => 'Error en servidor'], 500);
}


