<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Alumnos · Búsqueda y ficha</title>

  <link rel="stylesheet" href="https://code.jquery.com/ui/1.14.1/themes/base/jquery-ui.css">
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
  <script src="https://code.jquery.com/ui/1.14.1/jquery-ui.min.js"></script>

  <style>
    :root { --gap: .85rem; }
    body { font-family: system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif; padding: 2rem; }
    .ui-autocomplete { max-height: 300px; overflow-y: auto; overflow-x: hidden; }
    .muted { color: #666; font-size: .9rem; }
    .grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(240px, 1fr)); gap: var(--gap); }
    .field { display:flex; flex-direction:column; }
    .field label { font-size:.9rem; color:#444; margin-bottom:.25rem; }
    .field input { padding:.5rem; border:1px solid #ccc; border-radius:.4rem; }
    #log { margin-top: 1rem; height: 120px; overflow:auto; border:1px solid #ddd; padding:.5rem; }
    .spinner { display:none; width:1em; height:1em; border:2px solid #ccc; border-right-color:transparent; border-radius:50%; animation:spin .6s linear infinite; vertical-align:middle; }
    @keyframes spin { to { transform: rotate(360deg); } }
  </style>

  <script>
  $(function () {
    const $input = $("#alumno");
    const $loading = $("#loading");
    const $log = $("#log");

    // Lista de campos EXACTAMENTE igual que los nombres de columnas de tu tabla
    const fields = [
      'id','anno','nre','expediente','nombre','apellidos','apellido1','apellido2',
      'dni','curso','grupo','subgrupo','fecha_nacimiento','telefono','telefono2',
      'email_personal','email_oficial'
    ];

    function fillFromItem(item) {
      fields.forEach(f => {
        const $el = $(`[name="${f}"]`);
        if ($el.length) {
          let v = item[f] ?? '';
          if (f === 'fecha_nacimiento' && v) v = String(v).slice(0,10); // por si viene con hora
          $el.val(v);
        }
      });
    }

    $input.autocomplete({
      source: function(request, response) {
        $loading.show();
        $.ajax({
          url: "alumnos_autocomplete.php",
          dataType: "json",
          data: { term: request.term, limit: 20 }
        })
        .done(data => response(Array.isArray(data) ? data : []))
        .fail(() => response([]))
        .always(() => $loading.hide());
      },
      minLength: 1,
      delay: 120,
      select: function (event, ui) {
        // Rellenar la ficha directamente con los datos devueltos por alumnos_autocomplete.php
        fillFromItem(ui.item);
  
      }
    });

    // Opcional: limpiar ficha si vacías el input
    $input.on('input', function() {
      if (!this.value) {
        fields.forEach(f => $(`[name="${f}"]`).val(''));
      }
    });
  });
  </script>
</head>
<body>
<?php
// alumnos_ficha.php
  require_once 'menu.php';
?>
  <div style="max-width:720px;">
    <label for="alumno">Buscar alumno</label>
    <div style="display:flex; align-items:center; gap:.5rem;">
      <input id="alumno" placeholder="Nombre, apellidos, DNI, NRE o expediente" style="flex:1;">
      <span id="loading" class="spinner" title="Buscando..."></span>
    </div>
    <div class="muted">Escribe y selecciona un alumno. La ficha se completa automáticamente.</div>
  </div>

  <!-- FICHA: inputs con name = nombres de columnas -->
  <form class="grid" autocomplete="off" style="margin-top:1.25rem;">
    <div class="field"><label>ID</label><input name="id" readonly></div>
    <div class="field"><label>Año académico</label><input name="anno" placeholder="2025/2026"></div>
    <div class="field"><label>NRE</label><input name="nre"></div>
    <div class="field"><label>Expediente</label><input name="expediente"></div>
    <div class="field"><label>Nombre</label><input name="nombre"></div>
    <div class="field"><label>Apellidos</label><input name="apellidos"></div>
    <div class="field"><label>Primer apellido</label><input name="apellido1"></div>
    <div class="field"><label>Segundo apellido</label><input name="apellido2"></div>
    <div class="field"><label>DNI</label><input name="dni"></div>
    <div class="field"><label>Curso</label><input name="curso"></div>
    <div class="field"><label>Grupo</label><input name="grupo"></div>
    <div class="field"><label>Subgrupo</label><input name="subgrupo"></div>
    <div class="field"><label>Fecha de nacimiento</label><input name="fecha_nacimiento" type="date"></div>
    <div class="field"><label>Teléfono</label><input name="telefono"></div>
    <div class="field"><label>Teléfono 2</label><input name="telefono2"></div>
    <div class="field"><label>Email personal</label><input name="email_personal" type="email"></div>
    <div class="field"><label>Email oficial</label><input name="email_oficial" type="email"></div>
  </form>
<!-- Controles de matrícula -->
<div style="margin-top:1.25rem; max-width:720px;">
  <label for="sel_modulos">Módulos</label>
  <select id="sel_modulos" multiple size="6" style="width:100%;"></select>
  <div style="margin-top:.5rem; display:flex; gap:.5rem;">
    <button type="button" id="btn_matricular">Matricular</button>
  </div>
  <div id="msg_matricula" class="muted" style="margin-top:.5rem;"></div>
</div>
<!-- Lista de matrículas del alumno -->
<div style="margin-top:1.25rem; max-width:720px;">
  <div style="display:flex; align-items:end; gap:.5rem;">
    <div style="flex:1;">
      <label for="anno_lista">Año a mostrar</label>
      <input id="anno_lista" placeholder="2025/2026">
      <div class="muted">Si lo dejas vacío, se mostrarán <em>todas</em> las matrículas del alumno.</div>
    </div>
    <button type="button" id="btn_recargar_matriculas">Recargar lista</button>
  </div>

  <div id="matriculas_panel" style="margin-top:.75rem;">
    <div class="muted">Selecciona un alumno para ver sus matrículas…</div>
  </div>
</div>




<script>
// Cargar lista de módulos al abrir la página
$(function(){
  $.getJSON('modulos_list.php')
    .done(rows => {
      const $sel = $('#sel_modulos').empty();
      rows.forEach(r => {
        $('<option>').val(r.id).text(r.nombre).appendTo($sel);
      });
    });

  // Matrícula
  $('#btn_matricular').on('click', function(){
    const id_alumno = $('[name="id"]').val();
    const anno = $('[name="anno"]').val();
    const modulos = $('#sel_modulos').val() || []; // array de ids seleccionados

    if (!id_alumno) { alert('Selecciona un alumno primero.'); return; }
    if (!anno) { alert('Indica el año académico (anno).'); return; }
    if (modulos.length === 0) { alert('Selecciona al menos un módulo.'); return; }

    const payload = { id_alumno: parseInt(id_alumno,10), anno: anno, modulos: modulos.map(Number) };

    $.ajax({
      url: 'matricular_modulos.php',
      method: 'POST',
      data: JSON.stringify(payload),
      contentType: 'application/json; charset=utf-8',
      dataType: 'json'
    })
    .done(resp => {
      if (!resp || !resp.ok) {
        $('#msg_matricula').text('Error: ' + (resp && resp.error ? resp.error : 'desconocido'));
        return;
      }
      const r = resp.resumen || {};
      $('#msg_matricula').text(
        `Matriculación: ${r.insertados||0} nuevas, ${r.duplicados||0} ya existentes` +
        (resp.modulos_no_encontrados?.length ? `, no encontrados: ${resp.modulos_no_encontrados.join(', ')}` : '')
      );
    })
    .fail(xhr => {
      $('#msg_matricula').text('Error de red o servidor.');
      console.error(xhr.responseText);
    });
  });
});
</script>

<script>

function renderMatriculas(rows) {
    
    const id_alumno_sel = $('[name="id"]').val(); // id del alumno seleccionado

  const $p = $('#matriculas_panel').empty();

  if (!Array.isArray(rows) || rows.length === 0) {
    $p.html('<div class="muted">No hay matrículas para los filtros indicados.</div>');
    return;
  }

  const $table = $('<table style="width:100%; border-collapse:collapse;">');
  $table.append(`
    <thead>
      <tr>
        <th style="text-align:left; border-bottom:1px solid #ddd; padding:.4rem;">Año</th>
        <th style="text-align:left; border-bottom:1px solid #ddd; padding:.4rem;">Módulo</th>
        <th style="text-align:left; border-bottom:1px solid #ddd; padding:.4rem;">ID módulo</th>
        <th style="text-align:left; border-bottom:1px solid #ddd; padding:.4rem;">Fecha alta</th>
      </tr>
    </thead>
    <tbody></tbody>
  `);

  rows.forEach(r => {
      
    const fecha = r.fecha ? String(r.fecha).replace('T',' ').slice(0,19) : '';

    
    const id_alumno_sel = $('[name="id"]').val(); // mejor fuera del forEach, arriba de la función
const url = `alumno_instrumentos.php?id_alumno=${encodeURIComponent(id_alumno_sel)}&id_modulo=${encodeURIComponent(r.id_modulo)}&anno=${encodeURIComponent(r.anno || '')}`;



    $table.find('tbody').append(`
      <tr>
        <td style="border-bottom:1px solid #f0f0f0; padding:.4rem;">${r.anno || ''}</td>
        <td style="border-bottom:1px solid #f0f0f0; padding:.4rem;">
          <a href="${url}">${r.modulo_nombre || ''}</a>
        </td>
        <td style="border-bottom:1px solid #f0f0f0; padding:.4rem;">${r.id_modulo || ''}</td>
        <td style="border-bottom:1px solid #f0f0f0; padding:.4rem;">${fecha}</td>
      </tr>
    `);
  });

  $p.append($table);
}





function cargarMatriculas(id_alumno, anno = '') {
  if (!id_alumno) {
    $('#matriculas_panel').html('<div class="muted">Selecciona un alumno para ver sus matrículas…</div>');
    return;
  }
  const params = { id_alumno: parseInt(id_alumno,10) };
  if (anno) params.anno = anno;

$.getJSON('alumno_matriculas.php', params)
  .done(rows => renderMatriculas(rows))
  .fail((xhr, status, err) => {
    const body = (xhr && xhr.responseText) ? xhr.responseText.slice(0, 400) : '(sin cuerpo)';
    $('#matriculas_panel').html(
      `<div class="muted">Error al cargar la lista.
      <br><strong>HTTP:</strong> ${xhr.status || '¿?'}
      <br><strong>Status:</strong> ${status}
      <br><strong>Detalle:</strong> ${err || '—'}
      <pre style="white-space:pre-wrap;border:1px solid #eee;padding:.5rem;max-height:200px;overflow:auto;">${$('<div>').text(body).html()}</pre></div>`
    );
    console.error('GET alumno_matriculas.php fallo:', {xhr, status, err});
  });

}

$(function(){
  // Cuando cambie el campo "Año a mostrar", recargamos
  $('#btn_recargar_matriculas').on('click', function(){
    const id_alumno = $('[name="id"]').val();
    const anno = $('#anno_lista').val().trim();
    cargarMatriculas(id_alumno, anno);
  });

  // Al seleccionar un alumno en el autocomplete:
  const origFillFromItem = window.fillFromItem;
  // Exponemos fillFromItem si no está en global
  if (typeof origFillFromItem !== 'function') {
    // Tomamos la versión ya definida en tu script
    // Para no complicar, interceptamos el select del autocomplete más abajo
  }

  // Intercepta el select del autocomplete ya existente:
  // Reemplaza tu función select actual por esta (o añade la llamada al final):
  $("#alumno").autocomplete("option", "select", function (event, ui) {
    // Rellenar la ficha
    (function fillFromItem(item){
      const fields = [
        'id','anno','nre','expediente','nombre','apellidos','apellido1','apellido2',
        'dni','curso','grupo','subgrupo','fecha_nacimiento','telefono','telefono2',
        'email_personal','email_oficial'
      ];
      fields.forEach(f => {
        const $el = $(`[name="${f}"]`);
        if ($el.length) {
          let v = item[f] ?? '';
          if (f === 'fecha_nacimiento' && v) v = String(v).slice(0,10);
          $el.val(v);
        }
      });
    })(ui.item);

    // Sincroniza el año del filtro con el de la ficha (si viene)
    const annoFicha = $('[name="anno"]').val();
    if (annoFicha && !$('#anno_lista').val()) {
      $('#anno_lista').val(annoFicha);
    }

    // Carga la lista de matrículas del alumno (filtrando por anno si está relleno)
    const id_alumno = ui.item.id;
    const annoFiltro = $('#anno_lista').val().trim();
    cargarMatriculas(id_alumno, annoFiltro);

    return false; // evita que jQuery UI reemplace el valor del input por label
  });

  // Después de matricular, refrescamos la lista
  const oldDoneMatricula = $.ajax;
  // No sobreescribimos $.ajax, simplemente añadimos al .done que ya tienes:
  $('#btn_matricular').off('click').on('click', function(){
    const id_alumno = $('[name="id"]').val();
    const anno = $('[name="anno"]').val();
    const modulos = $('#sel_modulos').val() || [];

    if (!id_alumno) { alert('Selecciona un alumno primero.'); return; }
    if (!anno) { alert('Indica el año académico (anno).'); return; }
    if (modulos.length === 0) { alert('Selecciona al menos un módulo.'); return; }

    const payload = { id_alumno: parseInt(id_alumno,10), anno: anno, modulos: modulos.map(Number) };

    $.ajax({
      url: 'matricular_modulos.php',
      method: 'POST',
      data: JSON.stringify(payload),
      contentType: 'application/json; charset=utf-8',
      dataType: 'json'
    })
    .done(resp => {
      if (!resp || !resp.ok) {
        $('#msg_matricula').text('Error: ' + (resp && resp.error ? resp.error : 'desconocido'));
        return;
      }
      const r = resp.resumen || {};
      $('#msg_matricula').text(
        `Matriculación: ${r.insertados||0} nuevas, ${r.duplicados||0} ya existentes` +
        (resp.modulos_no_encontrados?.length ? `, no encontrados: ${resp.modulos_no_encontrados.join(', ')}` : '')
      );
      // Refrescamos la lista (usando el filtro de año visible)
      const annoFiltro = $('#anno_lista').val().trim() || anno;
      $('#anno_lista').val(annoFiltro);
      cargarMatriculas(id_alumno, annoFiltro);
    })
    .fail(xhr => {
      $('#msg_matricula').text('Error de red o servidor.');
      console.error(xhr.responseText);
    });
  });

  // Si el usuario cambia el "Año académico" de la ficha, sincronizamos el filtro
  $('[name="anno"]').on('change', function(){
    const valor = $(this).val();
    $('#anno_lista').val(valor);
    const id_alumno = $('[name="id"]').val();
    cargarMatriculas(id_alumno, valor);
  });
});
</script>

</body>
</html>
