<?php
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/db_pdo.php';
try {
  $pdo = pdo_conn();
  $id_modulo = (int)($_GET['id_modulo'] ?? 0);
  $id_alumno = (int)($_GET['id_alumno'] ?? 0);
  $anno = trim((string)($_GET['anno'] ?? ''));
  $tri  = (string)($_GET['trimestre'] ?? '');

  if ($id_modulo<=0 || $id_alumno<=0) { http_response_code(400); echo json_encode([]); exit; }

  $sql = "SELECT i.*, n.nota
          FROM instrumentos i
          JOIN instrumentos_notas n ON n.id_instrumento = i.id AND n.id_alumno = :alu
          WHERE i.id_modulo = :mod";
  $prm = [':alu'=>$id_alumno, ':mod'=>$id_modulo];
  if ($anno!==''){ $sql.=" AND i.anno = :a"; $prm[':a']=$anno; }
  if ($tri!==''){ $sql.=" AND i.trimestre = :t"; $prm[':t']=(int)$tri; }
  $sql .= " ORDER BY i.trimestre, i.fecha, i.titulo";

  $st = $pdo->prepare($sql); $st->execute($prm);
  $rows = $st->fetchAll(PDO::FETCH_ASSOC);

  // Adjuntar criterios
  $ids = array_column($rows,'id'); $map=[];
  if ($ids) {
    $in = implode(',', array_fill(0,count($ids),'?'));
    $sqlc = "SELECT ic.id_instrumento, c.id, c.valor, ra.codigo AS codigo_ra
             FROM instrumento_criterios ic
             JOIN criterios_evaluacion c ON c.id = ic.id_criterio
             JOIN resultados_aprendizaje ra ON ra.id = c.id_resultados_aprendizaje
             WHERE ic.id_instrumento IN ($in)";
    $stc = $pdo->prepare($sqlc);
    foreach ($ids as $k=>$v) $stc->bindValue($k+1,(int)$v,PDO::PARAM_INT);
    $stc->execute();
    while($r=$stc->fetch(PDO::FETCH_ASSOC)){
      $map[$r['id_instrumento']][] = ['id'=>$r['id'],'valor'=>$r['valor'],'codigo_ra'=>$r['codigo_ra']];
    }
  }
  foreach($rows as &$r) $r['criterios'] = $map[$r['id']] ?? [];
  echo json_encode($rows);
} catch(Throwable $e){ http_response_code(500); echo json_encode([]); }
