<?php
// draft_add_criterios.php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__.'/includes/db.php';
function jerr($m,$c=400){ http_response_code($c); echo json_encode(['ok'=>false,'error'=>$m]); exit; }

$in = json_decode(file_get_contents('php://input'), true) ?: [];
$draft_id = (int)($in['draft_id'] ?? 0);
$ids = $in['ids'] ?? [];
if($draft_id<=0 || !is_array($ids) || empty($ids)) jerr('Parámetros inválidos');

try{
  $pdo = pdo_conn();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

  $ins = $pdo->prepare("INSERT IGNORE INTO instrumentos_draft_criterios (draft_id,id_criterio) VALUES (?,?)");
  foreach($ids as $idc){
    $idc = (int)$idc;
    if($idc>0) $ins->execute([$draft_id,$idc]);
  }
  echo json_encode(['ok'=>true]);
}catch(Throwable $e){ jerr($e->getMessage(),500); }
