<?php
// draft_commit.php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__.'/includes/db.php';
function jerr($m,$c=400){ http_response_code($c); echo json_encode(['ok'=>false,'error'=>$m]); exit; }

$in = json_decode(file_get_contents('php://input'), true) ?: [];
$draft_id = (int)($in['draft_id'] ?? 0);
if($draft_id<=0) jerr('draft_id requerido');

try{
  $pdo = pdo_conn();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $pdo->beginTransaction();

  // 1) Leer borrador
  $h = $pdo->prepare("SELECT * FROM instrumentos_drafts WHERE id=? FOR UPDATE");
  $h->execute([$draft_id]); $hdr = $h->fetch(PDO::FETCH_ASSOC);
  if(!$hdr) throw new RuntimeException('Borrador no encontrado');

  // 2) Criterios
  $c = $pdo->prepare("SELECT id_criterio FROM instrumentos_draft_criterios WHERE draft_id=?");
  $c->execute([$draft_id]); $crit = $c->fetchAll(PDO::FETCH_COLUMN,0);
  if(empty($crit)) throw new RuntimeException('El borrador no tiene criterios');

  // 3) Crear instrumento
  $insInst = $pdo->prepare("
    INSERT INTO instrumentos (id_criterio_evaluacion, anno, trimestre, titulo, descripcion, fecha, ponderacion, creado_at)
    VALUES (NULL, ?, ?, ?, ?, ?, ?, NOW())
  ");
  
  
  
  
  $insInst->execute([
    $hdr['anno'],
    $hdr['trimestre'] ?: null,
    $hdr['titulo'] ?: '',
    $hdr['descripcion'] ?: null,
    $hdr['fecha'] ?: null,
    $hdr['ponderacion'] ?: null
  ]);
  $id_instrumento = (int)$pdo->lastInsertId();

  // 4) Vincular criterios (instrumentos_criterios)
  $insIC = $pdo->prepare("INSERT INTO instrumentos_criterios (id_instrumento, id_criterio) VALUES (?,?)");
  foreach($crit as $idc){
    $insIC->execute([$id_instrumento, (int)$idc]);
  }

  // 5) Determinar alumnos
  $alumnos = [];
  if((int)$hdr['asignar_todos'] === 1){
    // todos matriculados en el módulo/año
    $al = $pdo->prepare("SELECT id FROM alumnos WHERE anno = ?"); // ajusta a tu lógica real de matrícula
    $al->execute([$hdr['anno']]);
    $alumnos = $al->fetchAll(PDO::FETCH_COLUMN,0);
  }else{
    $al = $pdo->prepare("SELECT id_alumno FROM instrumentos_draft_alumnos WHERE draft_id=?");
    $al->execute([$draft_id]);
    $alumnos = $al->fetchAll(PDO::FETCH_COLUMN,0);
  }

  // 6) Crear asignaciones (fila en instrumentos_notas con nota NULL)
  if(!empty($alumnos)){


// Por ESTA BUENA:
$insN = $pdo->prepare("INSERT IGNORE INTO instrumentos_notas (id_instrumento,id_alumno,nota,fecha) VALUES (?,?,NULL,NOW())");
 
    
    foreach($alumnos as $ida){
      $insN->execute([$id_instrumento,(int)$ida]);
    }
  }

  // 7) Borrar borrador
  $pdo->prepare("DELETE FROM instrumentos_drafts WHERE id=?")->execute([$draft_id]);

  $pdo->commit();
  echo json_encode(['ok'=>true,'id_instrumento'=>$id_instrumento]);
}catch(Throwable $e){
  if($pdo?->inTransaction()) $pdo->rollBack();
  jerr($e->getMessage(),500);
}
