<?php
// draft_list.php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__.'/includes/db.php';
function jerr($m,$c=400){ http_response_code($c); echo json_encode(['ok'=>false,'error'=>$m]); exit; }

$draft_id = isset($_GET['draft_id'])?(int)$_GET['draft_id']:0;
if($draft_id<=0) jerr('draft_id requerido');

try{
  $pdo = pdo_conn();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

  // cabecera (por si quieres mostrar algo)
  $h = $pdo->prepare("SELECT * FROM instrumentos_drafts WHERE id=? LIMIT 1");
  $h->execute([$draft_id]); 
  $hdr = $h->fetch(PDO::FETCH_ASSOC);

  // criterios del borrador
  $c = $pdo->prepare("
    SELECT 
      c.id,
      COALESCE(ra.codigo, CONCAT('RA ', ra.id)) AS codigo_ra,
      c.criterio,
      c.valor
    FROM instrumentos_draft_criterios dc
    JOIN criterios_evaluacion c ON c.id = dc.id_criterio
    LEFT JOIN resultados_aprendizaje ra ON ra.id = c.id_resultados_aprendizaje
    WHERE dc.draft_id = ?
    ORDER BY ra.id, c.id
  ");
  $c->execute([$draft_id]); 
  $crit = $c->fetchAll(PDO::FETCH_ASSOC);

  echo json_encode(['ok'=>true,'draft'=>$hdr,'criterios'=>$crit]);
}catch(Throwable $e){ jerr($e->getMessage(),500); }

