<?php
// draft_remove_criterios.php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__.'/includes/db.php';
function jerr($m,$c=400){ http_response_code($c); echo json_encode(['ok'=>false,'error'=>$m]); exit; }

$in = json_decode(file_get_contents('php://input'), true) ?: [];
$draft_id = (int)($in['draft_id'] ?? 0);
$ids = $in['ids'] ?? [];
if($draft_id<=0) jerr('Parámetros inválidos');

try{
  $pdo = pdo_conn();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

  if(is_array($ids) && !empty($ids)){
    $place = implode(',', array_fill(0, count($ids), '?'));
    $args = array_merge([$draft_id], array_map('intval',$ids));
    $sql = "DELETE FROM instrumentos_draft_criterios WHERE draft_id=? AND id_criterio IN ($place)";
    $st = $pdo->prepare($sql); $st->execute($args);
  }else{
    // quitar todos
    $st = $pdo->prepare("DELETE FROM instrumentos_draft_criterios WHERE draft_id=?");
    $st->execute([$draft_id]);
  }
  echo json_encode(['ok'=>true]);
}catch(Throwable $e){ jerr($e->getMessage(),500); }
