<?php
// draft_set_alumnos.php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__.'/includes/db.php';
function jerr($m,$c=400){ http_response_code($c); echo json_encode(['ok'=>false,'error'=>$m]); exit; }

$in = json_decode(file_get_contents('php://input'), true) ?: [];
$draft_id = (int)($in['draft_id'] ?? 0);
$asignar_todos = (int)($in['asignar_todos'] ?? 1);
$alumnos = $in['alumnos'] ?? [];

if($draft_id<=0) jerr('draft_id requerido');

try{
  $pdo = pdo_conn();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

  // flag
  $pdo->prepare("UPDATE instrumentos_drafts SET asignar_todos=? WHERE id=?")->execute([$asignar_todos,$draft_id]);

  // lista
 $pdo->prepare("DELETE FROM instrumentos_draft_alumnos WHERE draft_id=?")->execute([$draft_id]); // <-- todo seguido

  if(!$asignar_todos && is_array($alumnos)){
    $ins = $pdo->prepare("INSERT IGNORE INTO instrumentos_draft_alumnos (draft_id,id_alumno) VALUES (?,?)");
    foreach($alumnos as $a){
      $a=(int)$a; if($a>0) $ins->execute([$draft_id,$a]);
    }
  }
  echo json_encode(['ok'=>true]);
}catch(Throwable $e){ jerr($e->getMessage(),500); }
