<?php
// draft_start.php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__.'/includes/db.php';
function jerr($msg,$code=400){ http_response_code($code); echo json_encode(['ok'=>false,'error'=>$msg]); exit; }

$raw = file_get_contents('php://input');
$in  = json_decode($raw,true) ?: $_POST;
$id_modulo = isset($in['id_modulo']) ? (int)$in['id_modulo'] : 0;
$anno = trim($in['anno'] ?? '');

if($id_modulo<=0 || $anno==='') jerr('Parámetros inválidos');

try{
  $pdo = pdo_conn();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $token = session_id();

  // Crea borrador nuevo
$st = $pdo->prepare("INSERT INTO instrumentos_drafts (session_token,id_modulo,anno) VALUES (?,?,?)");
$st->execute([$token,$id_modulo,$anno]);   // <-- DEBE ir así (una sola línea)

  echo json_encode(['ok'=>true,'draft_id'=>$pdo->lastInsertId()]);
}catch(Throwable $e){
  jerr($e->getMessage(),500);
}
