<?php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');
require_once 'includes/db.php';

try {
    $idCriterio  = isset($_POST['id_criterio'])  && ctype_digit((string)$_POST['id_criterio'])  ? (int)$_POST['id_criterio']  : 0;
    $idResultado = isset($_POST['id_resultado']) && ctype_digit((string)$_POST['id_resultado']) ? (int)$_POST['id_resultado'] : 0;
    $criterio    = isset($_POST['criterio']) ? trim((string)$_POST['criterio']) : '';

    if ($idResultado <= 0 || $criterio === '') {
        http_response_code(400);
        echo json_encode(['error' => 'Datos incompletos']); exit;
    }

    if ($idCriterio > 0) {
        // UPDATE
        $sql = "UPDATE criterios_evaluacion SET criterio = :criterio WHERE id = :id";
        $stmt = $conn->prepare($sql);
        $stmt->bindValue(':criterio', $criterio, PDO::PARAM_STR);
        $stmt->bindValue(':id', $idCriterio, PDO::PARAM_INT);
        $stmt->execute();
        echo json_encode(['ok' => true, 'mensaje' => 'Criterio actualizado']);
    } else {
        // INSERT
        $sql = "INSERT INTO criterios_evaluacion (id_resultados_aprendizaje, criterio) VALUES (:idra, :criterio)";
        $stmt = $conn->prepare($sql);
        $stmt->bindValue(':idra', $idResultado, PDO::PARAM_INT);
        $stmt->bindValue(':criterio', $criterio, PDO::PARAM_STR);
        $stmt->execute();
        echo json_encode(['ok' => true, 'mensaje' => 'Criterio añadido', 'id' => (int)$conn->lastInsertId()]);
    }
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Error del servidor']);
}

