<?php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');
require_once 'includes/db.php';

try {
    $idModulo = isset($_POST['id_modulo']) && ctype_digit((string)$_POST['id_modulo']) ? (int)$_POST['id_modulo'] : 0;
    $idRA     = isset($_POST['id_ra']) && ctype_digit((string)$_POST['id_ra']) ? (int)$_POST['id_ra'] : 0;
    $desc     = isset($_POST['descripcion']) ? trim((string)$_POST['descripcion']) : '';

    if ($idModulo <= 0 || $desc === '') {
        http_response_code(400);
        echo json_encode(['error' => 'Datos incompletos']); exit;
    }

    if ($idRA > 0) {
        // UPDATE con comprobación de pertenencia al módulo
        $sql = "UPDATE resultados_aprendizaje SET descripcion = :desc WHERE id = :id AND id_modulo = :idmod";
        $stmt = $conn->prepare($sql);
        $stmt->bindValue(':desc', $desc, PDO::PARAM_STR);
        $stmt->bindValue(':id', $idRA, PDO::PARAM_INT);
        $stmt->bindValue(':idmod', $idModulo, PDO::PARAM_INT);
        $stmt->execute();

        echo json_encode(['ok' => true, 'mensaje' => 'Resultado actualizado']);
    } else {
        // INSERT
        $sql = "INSERT INTO resultados_aprendizaje (id_modulo, descripcion) VALUES (:idmod, :desc)";
        $stmt = $conn->prepare($sql);
        $stmt->bindValue(':idmod', $idModulo, PDO::PARAM_INT);
        $stmt->bindValue(':desc', $desc, PDO::PARAM_STR);
        $stmt->execute();

        echo json_encode(['ok' => true, 'mensaje' => 'Resultado añadido', 'id' => (int)$conn->lastInsertId()]);
    }
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Error del servidor']);
}
