<?php
// instrumentos_delete.php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/includes/db.php';

$input = json_decode(file_get_contents('php://input'), true);
$id = isset($input['id_instrumento'])? (int)$input['id_instrumento'] : 0;
if($id<=0){ echo json_encode(['ok'=>false,'error'=>'id inválido']); exit; }

try{
  $pdo = pdo_conn();
  $pdo->beginTransaction();

  // Si NO tienes FK en cascada, descomenta:
  // $pdo->prepare("DELETE FROM instrumentos_notas WHERE id_instrumento=:id")->execute([':id'=>$id]);
  // $pdo->prepare("DELETE FROM instrumentos_criterios WHERE id_instrumento=:id")->execute([':id'=>$id]);

  $pdo->prepare("DELETE FROM instrumentos WHERE id=:id")->execute([':id'=>$id]);

  $pdo->commit();
  echo json_encode(['ok'=>true]);
}catch(Throwable $e){
  if($pdo && $pdo->inTransaction()) $pdo->rollBack();
  echo json_encode(['ok'=>false,'error'=>$e->getMessage()]);
}
