<?php
// instrumentos_evaluacion.php
require_once __DIR__ . '/menu.php';
require_once __DIR__ . '/includes/db.php';

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

$anno = isset($_GET['anno']) ? (string)$_GET['anno'] : '';

// DEFAULT por curso escolar España (septiembre a agosto)
$now = new DateTime('now', new DateTimeZone('Europe/Madrid'));
$y = (int)$now->format('Y');
$m = (int)$now->format('n');
$anno_default = ($m >= 9) ? ($y . '/' . ($y+1)) : (($y-1) . '/' . $y);


try {
  $pdo = pdo_conn();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $mods = $pdo->query("SELECT id, nombre FROM modulos ORDER BY nombre")->fetchAll(PDO::FETCH_ASSOC);
} catch (Throwable $e) {
  http_response_code(500);
  echo "Error de servidor: ".h($e->getMessage());
  exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Nuevo instrumento de evaluación</title>

<link rel="stylesheet" href="https://code.jquery.com/ui/1.14.1/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://code.jquery.com/ui/1.14.1/jquery-ui.min.js"></script>

<style>
  body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;padding:1.25rem;max-width:1100px;margin:auto}
  .grid{display:grid;gap:1rem}
  .grid-2{grid-template-columns:1fr 1fr}
  .grid-3{grid-template-columns:1fr auto 1fr}
  .field{display:flex;flex-direction:column;gap:.25rem}
  .muted{color:#666}
  input,select,textarea{padding:.5rem;border:1px solid #ccc;border-radius:.5rem}
  .card{border:1px solid #e5e7eb;border-radius:.75rem;padding:1rem;background:#fafafa}
  .btns-v{display:flex;flex-direction:column;gap:.5rem;align-items:center;justify-content:center}
  button{padding:.45rem .8rem;border:1px solid #ddd;border-radius:.6rem;background:#fff;cursor:pointer}
  button.primary{background:#0ea5e9;color:#fff;border-color:#0ea5e9}
</style>

<script>
  window.APP = { ANNO: <?= json_encode($anno) ?> };
</script>
<script src="instrumentos_evaluacion.js?v=2"></script>
</head>
<body>

<h1>Nuevo instrumento de evaluación</h1>
<p class="muted">Crea un instrumento para un módulo, selecciona RA y criterios, y asígnalo a todo el grupo o a alumnos concretos.</p>

<div class="card" style="margin-bottom:1rem">
  <div class="grid grid-2">
    <div class="field">
      <label>Año académico</label>
    
      <input id="f_anno" placeholder="2025/2026" value="<?= h($anno ?: $anno_default) ?>">

      
      
    </div>
    <div class="field">
      <label>Módulo</label>
      <select id="f_modulo">
        <option value="">— Selecciona módulo —</option>
        <?php foreach($mods as $m): ?>
          <option value="<?= (int)$m['id'] ?>"><?= h($m['nombre']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
  </div>
</div>

<div class="card" style="margin-bottom:1rem">
  <div class="grid grid-2">
    <div class="field">
      <label>Título del instrumento</label>
      <input id="i_titulo" placeholder="p.ej. Prueba corta RA1-RA2">
    </div>
    <div class="field">
      <label>Ponderación (0-100)</label>
      <input id="i_ponderacion" type="number" min="0" max="100" placeholder="p.ej. 20">
    </div>
    <div class="field">
      <label>Fecha</label>
      <input id="i_fecha" type="date">
    </div>
    <div class="field">
      <label>Trimestre</label>
      <select id="i_trimestre">
        <option value="1">1º</option><option value="2">2º</option><option value="3">3º</option>
      </select>
    </div>
    <div class="field" style="grid-column:1/-1">
      <label>Descripción</label>
      <textarea id="i_descripcion" rows="3" placeholder="Detalle del instrumento, materiales, rúbrica, etc."></textarea>
    </div>
  </div>
</div>

<div class="card" style="margin-bottom:1rem">
  <div class="field" style="margin-bottom:.5rem">
    <label>Resultados de aprendizaje del módulo</label>
    <select id="sel_ra" multiple size="4"></select>
    <div class="muted">Selecciona uno o varios RA. Los criterios disponibles se filtran automáticamente.</div>
  </div>

  <div class="grid grid-3" style="align-items:start">
    <div class="field">
      <label>Criterios disponibles</label>
      <input id="filtro_av" placeholder="Filtrar…" style="margin-bottom:.25rem">
      <select id="sel_criterios_av" multiple size="12" style="width:100%"></select>
    </div>

    <div class="btns-v" style="padding-top:1.8rem">
      <button id="btn_add">&raquo; Añadir</button>
      <button id="btn_add_all">&raquo;&raquo; Añadir todos</button>
      <button id="btn_remove">&laquo; Quitar</button>
      <button id="btn_remove_all">&laquo;&laquo; Quitar todos</button>
    </div>

    <div class="field">
      <label>Criterios seleccionados (se guardarán)</label>
      <select id="sel_criterios_sel" multiple size="12" style="width:100%"></select>
    </div>
  </div>
</div>

<div class="card" style="margin-bottom:1rem">
  <div class="field">
    <label><input type="checkbox" id="i_asignar_todos" checked> Asignar a todos los alumnos del módulo/año</label>
  </div>
  <div class="field">
    <label>Alumnos (si NO es a todos)</label>
    <select id="sel_alumnos" multiple size="8" disabled style="width:100%"></select>
  </div>
</div>

<div style="display:flex;gap:.5rem">
  <button class="primary" id="btn_guardar">Guardar instrumento</button>
  <div id="msg" class="muted" style="padding-top:.5rem"></div>
</div>

</body>
</html>

