<?php
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/db_pdo.php';
try{
  $pdo = pdo_conn();
  $in = json_decode(file_get_contents('php://input'), true) ?: [];
  $id_instrumento = (int)($in['id_instrumento'] ?? 0);
  $id_alumno = (int)($in['id_alumno'] ?? 0);
  $nota = $in['nota'] ?? null;

  if ($id_instrumento<=0 || $id_alumno<=0) { echo json_encode(['ok'=>false,'error'=>'Parámetros inválidos']); exit; }

  $sql = "INSERT INTO instrumentos_notas (id_instrumento,id_alumno,nota)
          VALUES (:i,:a,:n)
          ON DUPLICATE KEY UPDATE nota=VALUES(nota)";
  $st = $pdo->prepare($sql);
  $st->execute([':i'=>$id_instrumento, ':a'=>$id_alumno, ':n'=>$nota]);

  echo json_encode(['ok'=>true]);
}catch(Throwable $e){ error_log('[nota_save] '.$e->getMessage()); echo json_encode(['ok'=>false,'error'=>'Error en servidor']); }
