<?php
// modulo_instrumentos.php
require_once __DIR__ . '/menu.php';
$id_modulo = isset($_GET['id_modulo']) ? (int)$_GET['id_modulo'] : 0;
$anno = isset($_GET['anno']) ? $_GET['anno'] : '';
if ($id_modulo <= 0) { http_response_code(400); echo "Falta id_modulo"; exit; }
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title>Instrumentos de evaluación</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://code.jquery.com/ui/1.14.1/themes/base/jquery-ui.css">
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
  <script src="https://code.jquery.com/ui/1.14.1/jquery-ui.min.js"></script>
  <style>
    body { font-family: system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif; padding: 1.25rem; }
    .grid { display:grid; grid-template-columns: 1fr 2fr; gap:1rem; max-width:1100px; }
    table { width:100%; border-collapse: collapse; }
    th, td { padding:.5rem; border-bottom:1px solid #eee; text-align:left; }
    .muted { color:#666; }
    .field { display:flex; flex-direction:column; gap:.25rem; }
    input, select, textarea { padding:.5rem; border:1px solid #ccc; border-radius:.4rem; }
    .actions button { margin-right:.5rem; }
    .pill { display:inline-block; padding:.15rem .5rem; border:1px solid #ddd; border-radius:999px; margin:.15rem; font-size:.85rem; }
  </style>
</head>
<body>
  <h1>Instrumentos de evaluación</h1>
  <div class="muted">Módulo ID: <?php echo htmlspecialchars($id_modulo) ?> · Año: <?php echo htmlspecialchars($anno ?: '—'); ?></div>

  <div class="grid" style="margin-top:1rem;">
    <!-- Panel izquierdo: filtros + formulario -->
    <div>
      <div class="field">
        <label>Año académico</label>
        <input id="f_anno" placeholder="2025/2026" value="<?php echo htmlspecialchars($anno); ?>">
      </div>
      <div class="field" style="margin-top:.5rem;">
        <label>Trimestre</label>
        <select id="f_trimestre">
          <option value="">Todos</option>
          <option value="1">1º</option>
          <option value="2">2º</option>
          <option value="3">3º</option>
        </select>
      </div>
      <div style="margin-top:.5rem;">
        <button id="btn_filtrar">Filtrar</button>
        <button id="btn_nuevo">Nuevo instrumento</button>
      </div>

      <hr style="margin:1rem 0;">

      <h3 id="form_title">Nuevo/Editar instrumento</h3>
      <form id="frm" autocomplete="off">
        <input type="hidden" id="id" value="">
        <div class="field"><label>Título</label><input id="titulo"></div>
        <div class="field"><label>Descripción</label><textarea id="descripcion" rows="4"></textarea></div>
        <div class="field"><label>Fecha</label><input id="fecha" type="date"></div>
        <div class="field"><label>Trimestre</label>
          <select id="trimestre">
            <option value="1">1º</option><option value="2">2º</option><option value="3">3º</option>
          </select>
        </div>
        <div class="field"><label>Ponderación (0-100)</label><input id="ponderacion" type="number" min="0" max="100"></div>

        <div class="field">
          <label>Resultados de aprendizaje</label>
          <select id="sel_ra" multiple size="5"></select>
          <div class="muted">Selecciona RA para filtrar criterios sugeridos.</div>
        </div>

        <div class="field">
          <label>Criterios de evaluación (asociados al instrumento)</label>
          <select id="sel_criterios" multiple size="8"></select>
          <div class="muted">El peso de cada criterio está en su campo <em>valor</em> (tabla criterios_evaluacion).</div>
        </div>

        <div style="margin-top:.5rem;">
          <button type="button" id="btn_guardar">Guardar</button>
          <button type="button" id="btn_cancelar">Cancelar</button>
        </div>
        <div id="msg" class="muted" style="margin-top:.5rem;"></div>
      </form>
    </div>

    <!-- Panel derecho: lista -->
    <div>
      <div class="muted" id="resumen"></div>
      <table id="tbl">
        <thead>
          <tr>
            <th>Trimestre</th>
            <th>Título</th>
            <th>Fecha</th>
            <th>Pond.</th>
            <th>Criterios</th>
            <th></th>
          </tr>
        </thead>
        <tbody></tbody>
      </table>
    </div>
  </div>

<script>
const ID_MOD = <?php echo (int)$id_modulo; ?>;
$(function(){
  // Cargar RA para el módulo
  function cargarRA() {
    return $.getJSON('ra_list.php', { id_modulo: ID_MOD }).done(rows => {
      const $ra = $('#sel_ra').empty();
      rows.forEach(r => $('<option>').val(r.id).text(`${r.codigo} · ${r.descripcion}`).appendTo($ra));
    });
  }

  // Cargar criterios (opcionalmente filtrando por RA seleccionados)
  function cargarCriterios() {
    const ras = $('#sel_ra').val() || [];
    return $.ajax({
      url: 'criterios_list.php',
      data: { id_modulo: ID_MOD, ra: ras }, // ra[]=...
      traditional: true,
      dataType: 'json'
    }).done(rows => {
      const $c = $('#sel_criterios').empty();
      rows.forEach(r => $('<option>').val(r.id).text(`${r.codigo_ra || ''} · ${r.criterio} (v=${r.valor})`).appendTo($c));
    });
  }

  function renderTabla(rows) {
    const $tb = $('#tbl tbody').empty();
    $('#resumen').text(`${rows.length} instrumentos encontrados`);
    rows.forEach(r => {
      const crits = (r.criterios || []).map(c => `<span class="pill">${c.codigo_ra || ''}#${c.id}: v=${c.valor}</span>`).join(' ');
      $tb.append(`
        <tr>
          <td>${r.trimestre}</td>
          <td>${r.titulo}</td>
          <td>${r.fecha || ''}</td>
          <td>${r.ponderacion ?? ''}</td>
          <td>${crits}</td>
          <td class="actions">
            <button data-id="${r.id}" class="btn_edit">Editar</button>
            <button data-id="${r.id}" class="btn_del">Borrar</button>
          </td>
        </tr>
      `);
    });
  }

  function cargarLista() {
    const anno = $('#f_anno').val().trim();
    const trimestre = $('#f_trimestre').val();
    $.getJSON('instrumentos_list.php', { id_modulo: ID_MOD, anno, trimestre })
      .done(renderTabla)
      .fail(()=>{ $('#resumen').text('No se pudo cargar la lista.'); });
  }

  // Guardar (crear/editar)
  $('#btn_guardar').on('click', function(){
    const payload = {
      id: $('#id').val() ? parseInt($('#id').val(),10) : null,
      id_modulo: ID_MOD,
      anno: $('#f_anno').val().trim(),
      titulo: $('#titulo').val().trim(),
      descripcion: $('#descripcion').val().trim(),
      fecha: $('#fecha').val() || null,
      trimestre: parseInt($('#trimestre').val(),10),
      ponderacion: $('#ponderacion').val() ? parseInt($('#ponderacion').val(),10) : null,
      criterios: ($('#sel_criterios').val() || []).map(Number)
    };
    if (!payload.anno) { alert('Indica el año académico'); return; }
    if (!payload.titulo) { alert('Indica un título'); return; }

    $.ajax({
      url: 'instrumentos_save.php',
      method: 'POST',
      data: JSON.stringify(payload),
      contentType: 'application/json; charset=utf-8',
      dataType: 'json'
    })
    .done(resp => {
      if (!resp.ok) { $('#msg').text(resp.error || 'Error'); return; }
      $('#msg').text('Guardado.');
      $('#frm')[0].reset(); $('#id').val('');
      cargarLista();
    })
    .fail(()=> $('#msg').text('Error de red/servidor'));
  });

  // Editar
  $('#tbl').on('click', '.btn_edit', function(){
    const id = $(this).data('id');
    $.getJSON('instrumentos_get.php', { id })
      .done(r => {
        $('#id').val(r.id);
        $('#titulo').val(r.titulo);
        $('#descripcion').val(r.descripcion || '');
        $('#fecha').val(r.fecha || '');
        $('#trimestre').val(r.trimestre);
        $('#ponderacion').val(r.ponderacion ?? '');
        $('#f_anno').val(r.anno);
        // Seleccionar criterios asociados
        const sel = (r.criterios || []).map(c => String(c.id_criterio));
        $('#sel_criterios').val(sel);
        $('#form_title').text('Editar instrumento');
      });
  });

  // Borrar
  $('#tbl').on('click', '.btn_del', function(){
    const id = $(this).data('id');
    if (!confirm('¿Borrar este instrumento?')) return;
    $.post('instrumentos_delete.php', { id })
      .done(()=> cargarLista())
      .fail(()=> alert('No se pudo borrar'));
  });

  $('#btn_filtrar').on('click', cargarLista);
  $('#btn_nuevo').on('click', function(){
    $('#form_title').text('Nuevo instrumento');
    $('#frm')[0].reset(); $('#id').val('');
  });

  $('#sel_ra').on('change', cargarCriterios);

  // Inicialización
  cargarRA().then(cargarCriterios).then(cargarLista);
});
</script>
</body>
</html>
