<?php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');
require_once 'includes/db.php';

try {
    if (empty($_POST['id']) || !ctype_digit((string)$_POST['id'])) {
        http_response_code(400);
        echo json_encode(['error' => 'ID inválido']); exit;
    }
    $id = (int)$_POST['id'];

    $stmt = $conn->prepare("SELECT id, id_modulo, descripcion FROM resultados_aprendizaje WHERE id = :id");
    $stmt->bindValue(':id', $id, PDO::PARAM_INT);
    $stmt->execute();
    $row = $stmt->fetch();

    if (!$row) {
        http_response_code(404);
        echo json_encode(['error' => 'No encontrado']); exit;
    }

    echo json_encode($row);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Error del servidor']);
}
