<?php
session_start();
require_once 'includes/db.php';
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Relación entre Resultados de Aprendizaje, criterios de evaluación y contenidos</title>
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
    <style>
        .contenedor {
            display: flex;
            gap: 20px;
        }
        .columna {
            flex: 1;
            border: 1px solid #ccc;
            padding: 10px;
        }
        item { font-weight: bold; }
        ul { margin-left: 20px; }
    </style>
</head>
<body>

<?php
if (isset($_GET['id']) && is_numeric($_GET['id'])) {
    $id = (int) $_GET['id'];

    // Módulo
    $stmt = $conn->prepare("SELECT * FROM modulos WHERE id = :id");
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    $stmt->execute();
    $modulo = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($modulo) {
        echo "<h1>Módulo: " . htmlspecialchars($modulo['nombre']) . "</h1>";

        // Listado RA del módulo
        $stmt = $conn->prepare("SELECT * FROM resultados_aprendizaje WHERE id_modulo = :id_modulo");
        $stmt->bindParam(':id_modulo', $modulo['id'], PDO::PARAM_INT);
        $stmt->execute();
        $totalra = $stmt->rowCount();

        require_once 'menu.php';

        echo "<h2>Resultados de aprendizaje y criterios de evaluación</h2>";

        // Suma total de todos los CE del módulo
        $sm_ce = $conn->prepare("
            SELECT SUM(ce.valor) AS suma
            FROM modulos m
            JOIN resultados_aprendizaje ra ON ra.id_modulo = m.id
            JOIN criterios_evaluacion ce ON ce.id_resultados_aprendizaje = ra.id
            WHERE m.id = :id_modulo
        ");
        $sm_ce->bindParam(':id_modulo', $modulo['id'], PDO::PARAM_INT);
        $sm_ce->execute();
        $rsm_ce = $sm_ce->fetch(PDO::FETCH_ASSOC);
        $sumaModulo = $rsm_ce && isset($rsm_ce['suma']) ? (float)$rsm_ce['suma'] : 0;

        echo "<p>Valoración total de los Resultados de aprendizaje: <item id='totalRA'>" . $sumaModulo . "</item></p>";

        $cont = 0;
        while ($resultado = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $cont++;
            echo "<div style='border:1px solid #ccc; padding:10px; margin:10px;'>";
            echo "<h3>$cont - R.A.: " . htmlspecialchars($resultado['descripcion']) . "</h3>";

            // Suma de CE por RA
            $sm_cee = $conn->prepare("
                SELECT SUM(ce.valor) AS suma
                FROM resultados_aprendizaje ra
                JOIN criterios_evaluacion ce ON ce.id_resultados_aprendizaje = ra.id
                WHERE ra.id = :id_ra
            ");
            $sm_cee->bindParam(':id_ra', $resultado['id'], PDO::PARAM_INT);
            $sm_cee->execute();
            $rsm_cee = $sm_cee->fetch(PDO::FETCH_ASSOC);
            $sumaRA = $rsm_cee && isset($rsm_cee['suma']) ? (float)$rsm_cee['suma'] : 0;

            echo "<p>Valor del RA: <item id='ra{$resultado['id']}' class='ra$cont'>" . $sumaRA . "</item></p>";
            ?>

            <div class="contenedor">
                <div class="columna">
                    <h2>Bloques de contenido asociados al Resultado de aprendizaje</h2>
                    <button class='btn-relacionar' data-id='<?= (int)$resultado['id'] ?>'>Relacionar contenido con resultado</button>

                    <?php
                    // Consulta eficiente: trae Bloques, Contenidos y Subcontenidos de una vez
                    $todoStmt = $conn->prepare("
                        SELECT 
                            b.id           AS id_bloque,
                            b.nombre       AS nombre_bloque,
                            c.id           AS id_contenido,
                            c.nombre       AS nombre_contenido,
                            sc.nombre      AS nombre_subcontenido
                        FROM resultados_bloques rb
                        JOIN bloques_contenido b ON b.id = rb.id_bloque
                        LEFT JOIN contenidos c     ON c.id_bloque = b.id
                        LEFT JOIN subcontenidos sc ON sc.id_contenido = c.id
                        WHERE rb.id_resultado = :id_resultado
                        ORDER BY b.id, c.id, sc.id
                    ");
                    $todoStmt->bindParam(':id_resultado', $resultado['id'], PDO::PARAM_INT);
                    $todoStmt->execute();

                    $estructura = []; // [bloqueId => ['nombre'=>..., 'contenidos'=> [contId => ['nombre'=>..., 'subs'=>[...]]]]]
                    while ($row = $todoStmt->fetch(PDO::FETCH_ASSOC)) {
                        $bId  = $row['id_bloque'];
                        $bNom = $row['nombre_bloque'] ?? 'Bloque sin nombre';
                        $cId  = $row['id_contenido'];
                        $cNom = $row['nombre_contenido'];
                        $sNom = $row['nombre_subcontenido'];

                        if (!isset($estructura[$bId])) {
                            $estructura[$bId] = ['nombre' => $bNom, 'contenidos' => []];
                        }
                        if ($cId) {
                            if (!isset($estructura[$bId]['contenidos'][$cId])) {
                                $estructura[$bId]['contenidos'][$cId] = ['nombre' => $cNom, 'subs' => []];
                            }
                            if ($sNom) {
                                $estructura[$bId]['contenidos'][$cId]['subs'][] = $sNom;
                            }
                        }
                    }

                    if ($estructura) {
                        echo "<ul>";
                        foreach ($estructura as $bloque) {
                            echo "<li><b>" . htmlspecialchars($bloque['nombre']) . "</b>";
                            if (!empty($bloque['contenidos'])) {
                                echo "<ul>";
                                foreach ($bloque['contenidos'] as $contData) {
                                    echo "<li>" . htmlspecialchars($contData['nombre']);
                                    if (!empty($contData['subs'])) {
                                        echo "<ul>";
                                        foreach ($contData['subs'] as $subNom) {
                                            echo "<li>" . htmlspecialchars($subNom) . "</li>";
                                        }
                                        echo "</ul>";
                                    }
                                    echo "</li>";
                                }
                                echo "</ul>";
                            }
                            echo "</li>";
                        }
                        echo "</ul>";
                    } else {
                        echo "<p>No hay bloques asociados a este resultado.</p>";
                    }
                    ?>
                </div>

                <div class="columna">
                    <h2>Criterios de Evaluación</h2>
                    <ul id='lista-criterios-<?= (int)$resultado['id'] ?>'>
                        <?php
                        $ceStmt = $conn->prepare("
                            SELECT * 
                            FROM criterios_evaluacion 
                            WHERE id_resultados_aprendizaje = :id_resultado
                        ");
                        $ceStmt->bindParam(':id_resultado', $resultado['id'], PDO::PARAM_INT);
                        $ceStmt->execute();
                        $totalce = $ceStmt->rowCount();
                        $contce = 1;
                        while ($criterio = $ceStmt->fetch(PDO::FETCH_ASSOC)) {
                            $valorCE = isset($criterio['valor']) ? htmlspecialchars($criterio['valor']) : '';
                            echo "<li data-id='" . (int)$criterio['id'] . "'>";
                            echo htmlspecialchars($criterio['criterio']);
                            echo "<br><b>Ponderación:</b> ";
                            echo "<input id='pon{$resultado['id']}{$contce}' class='pon' data-idce='" . (int)$criterio['id'] . "' data-idra='" . (int)$resultado['id'] . "' data-total='" . (int)$totalce . "' size='4' value='" . $valorCE . "'>";
                            echo "</li>";
                            $contce++;
                        }
                        ?>
                    </ul>
                </div>
            </div>

            <?php
            echo "</div>";
        }
    } else {
        echo "Módulo no encontrado.";
    }
} else {
    echo "ID inválido.";
}
?>

<!-- Diálogo relacionar contenido - resultados -->
<div id="dialog-cont-resul" title="Relacionar contenidos con los resultados" style="display:none;">
    <form id="form-cont-result">
        <input type="hidden" id="id_resultado" name="id_resultado">
        <label for="bloque">Bloque de contenido:</label><br>
        <select name="bloque" id="bloque" required>
            <option value="">--Selecciona--</option>
            <?php
            // Llenado del combo de bloques por módulo
            if (isset($id)) {
                $bloques = $conn->prepare("SELECT * FROM bloques_contenido WHERE id_modulo = :id_modulo");
                $bloques->bindParam(':id_modulo', $id, PDO::PARAM_INT);
                $bloques->execute();
                $contador = 0;
                while ($bloque = $bloques->fetch(PDO::FETCH_ASSOC)) {
                    $contador++;
                    echo "<option value='" . (int)$bloque['id'] . "'>$contador.- " . htmlspecialchars($bloque['nombre']) . "</option>";
                }
            }
            ?>
        </select>
        <br><br>
        <input type="submit" value="Guardar">
    </form>
</div>

<script>
$(document).ready(function() {

    // Función para sumar todos los RA y mostrar el total
    function sumarTodosRA() {
        var total = 0;
        $("item[id^='ra']").each(function() {
            var valor = parseFloat($(this).text()) || 0;
            total += valor;
        });
        $("#totalRA").text(total);
    }

    // Cada vez que se modifica una ponderación
    $(document).on("input", ".pon", function() {
        var idce = $(this).data("idce");
        var idra = $(this).data("idra");
        var total = parseInt($(this).data("total"));
        var v = parseFloat($(this).val()) || 0;

        var suma = 0;
        for (let i = 1; i <= total; i++) {
            var valor = parseFloat($("#pon" + idra + i).val()) || 0;
            suma += valor;
        }

        $("#ra" + idra).text(suma);

        $.ajax({
            url: 'valor_ce.php',
            type: 'POST',
            data: { idce: idce, valor: v }
        });

        // Sumar todos los RA
        sumarTodosRA();
    });

    // Diálogo para relacionar contenido con resultados
    $("#dialog-cont-resul").dialog({
        autoOpen: false,
        modal: true,
        width: 400
    });

    $(".btn-relacionar").on("click", function() {
        var id_resultado = $(this).data("id");
        $("#id_resultado").val(id_resultado);
        $("#dialog-cont-resul").dialog("open");
    });

    $("#form-cont-result").on("submit", function(e) {
        e.preventDefault();
        $.ajax({
            url: 'guardar_relacion.php',
            type: 'POST',
            data: $(this).serialize(),
            success: function(respuesta) {
                alert(respuesta);
                if (respuesta.includes("✅")) {
                    location.reload();
                }
            },
            error: function() {
                alert("❌ Error al guardar la relación.");
            }
        });
    });

});
</script>
</body>
</html>
