<?php
session_start();
require_once 'includes/db.php';
$id_modulo=$_GET['id_modulo'];
// Protección de sesión


$mensaje = '';

// Procesar el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['id_modulo']) && !empty($_POST['descripcion'])) {
    $id_modulo = (int)$_POST['id_modulo'];
    $descripcion = trim($_POST['descripcion']);

    try {
        $stmt = $conn->prepare("INSERT INTO resultados_aprendizaje (id_modulo, descripcion) VALUES (:id_modulo, :descripcion)");
        $stmt->bindParam(':id_modulo', $id_modulo, PDO::PARAM_INT);
        $stmt->bindParam(':descripcion', $descripcion);
        $stmt->execute();
        $mensaje = "Resultado de aprendizaje añadido correctamente.";
    } catch (PDOException $e) {
        $mensaje = "Error al insertar resultado: " . $e->getMessage();
    }
}
?>

<h2>Alta de Resultados de Aprendizaje</h2>

<?php if ($mensaje): ?>
    <p><?php echo $mensaje; ?></p>
<?php endif; ?>

<form method="post">
    <label for="id_modulo">Módulo:</label><br>
    <select name="id_modulo" id="id_modulo" required>
        <option value="">Seleccione un módulo</option>
        <?php
        try {
            $stmt = $conn->query("SELECT * FROM modulos ORDER BY nombre");
            while ($row = $stmt->fetch()) {
                echo "<option value='{$row['id']}'>{$row['nombre']}</option>";
            }
        } catch (PDOException $e) {
            echo "<option>Error al cargar módulos: " . $e->getMessage() . "</option>";
        }
        ?>
    </select><br><br>

    <label for="descripcion">Descripción del Resultado de Aprendizaje:</label><br>
    <textarea name="descripcion" id="descripcion" rows="4" cols="50" required></textarea><br><br>

    <input type="submit" value="Guardar">
</form>

<hr>

<h3>Listado de Resultados de Aprendizaje por Módulo</h3>

<?php
try {
    $stmt = $conn->query("
        SELECT ra.id, ra.descripcion, m.nombre AS modulo
        FROM resultados_aprendizaje ra
        JOIN modulos m ON ra.id_modulo = m.id
        ORDER BY m.nombre, ra.id
    ");

    $moduloActual = '';
    while ($row = $stmt->fetch()) {
        if ($moduloActual !== $row['modulo']) {
            if ($moduloActual !== '') echo "</ul>";
            $moduloActual = $row['modulo'];
            echo "<h4>{$moduloActual}</h4><ul>";
        }
        echo "<li>{$row['descripcion']}</li>";
    }
    if ($moduloActual !== '') echo "</ul>";

} catch (PDOException $e) {
    echo "Error al listar resultados: " . $e->getMessage();
}
?>
